// Code generated by ctr_arm64_gen.go. DO NOT EDIT.

//go:build !purego

#include "textflag.h"

#define NR R9
#define XK R10
#define DST R11
#define SRC R12
#define IV_LOW_LE R16
#define IV_HIGH_LE R17
#define IV_LOW_BE R19
#define IV_HIGH_BE R20

// V0.B16 - V7.B16 are for blocks (<=8). See BLOCK_OFFSET.
// V8.B16 - V22.B16 are for <=15 round keys (<=15). See ROUND_KEY_OFFSET.
// V23.B16 - V30.B16 are for destinations (<=8). See DST_OFFSET.

// func ctrBlocks1Asm(nr int, xk *[60]uint32, dst *[1*16]byte, src *[1*16]byte, ivlo uint64, ivhi uint64)
TEXT ·ctrBlocks1Asm(SB), NOSPLIT, $0
	MOVD nr+0(FP), NR
	MOVD xk+8(FP), XK
	MOVD dst+16(FP), DST
	MOVD src+24(FP), SRC
	MOVD ivlo+32(FP), IV_LOW_LE
	MOVD ivhi+40(FP), IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V0.D[1]
	VMOV IV_HIGH_BE, V0.D[0]

	CMP $12, NR
	BLT Lenc128
	BEQ Lenc192

Lenc256:
	VLD1.P 32(XK), [V8.B16, V9.B16]

	AESE  V8.B16, V0.B16
	AESMC V0.B16, V0.B16

	AESE  V9.B16, V0.B16
	AESMC V0.B16, V0.B16

Lenc192:
	VLD1.P 32(XK), [V10.B16, V11.B16]

	AESE  V10.B16, V0.B16
	AESMC V0.B16, V0.B16

	AESE  V11.B16, V0.B16
	AESMC V0.B16, V0.B16

Lenc128:
	VLD1.P 64(XK), [V12.B16, V13.B16, V14.B16, V15.B16]
	VLD1.P 64(XK), [V16.B16, V17.B16, V18.B16, V19.B16]
	VLD1.P 48(XK), [V20.B16, V21.B16, V22.B16]

	AESE  V12.B16, V0.B16
	AESMC V0.B16, V0.B16

	AESE  V13.B16, V0.B16
	AESMC V0.B16, V0.B16

	AESE  V14.B16, V0.B16
	AESMC V0.B16, V0.B16

	AESE  V15.B16, V0.B16
	AESMC V0.B16, V0.B16

	AESE  V16.B16, V0.B16
	AESMC V0.B16, V0.B16

	AESE  V17.B16, V0.B16
	AESMC V0.B16, V0.B16

	AESE  V18.B16, V0.B16
	AESMC V0.B16, V0.B16

	AESE  V19.B16, V0.B16
	AESMC V0.B16, V0.B16

	AESE  V20.B16, V0.B16
	AESMC V0.B16, V0.B16

	AESE V21.B16, V0.B16

	VEOR V0.B16, V22.B16, V0.B16

	VLD1.P 16(SRC), [V23.B16]
	VEOR   V23.B16, V0.B16, V23.B16
	VST1.P [V23.B16], 16(DST)

	RET

// func ctrBlocks2Asm(nr int, xk *[60]uint32, dst *[2*16]byte, src *[2*16]byte, ivlo uint64, ivhi uint64)
TEXT ·ctrBlocks2Asm(SB), NOSPLIT, $0
	MOVD nr+0(FP), NR
	MOVD xk+8(FP), XK
	MOVD dst+16(FP), DST
	MOVD src+24(FP), SRC
	MOVD ivlo+32(FP), IV_LOW_LE
	MOVD ivhi+40(FP), IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V0.D[1]
	VMOV IV_HIGH_BE, V0.D[0]
	ADDS $1, IV_LOW_LE
	ADC  $0, IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V1.D[1]
	VMOV IV_HIGH_BE, V1.D[0]

	CMP $12, NR
	BLT Lenc128
	BEQ Lenc192

Lenc256:
	VLD1.P 32(XK), [V8.B16, V9.B16]

	AESE  V8.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V8.B16, V1.B16
	AESMC V1.B16, V1.B16

	AESE  V9.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V9.B16, V1.B16
	AESMC V1.B16, V1.B16

Lenc192:
	VLD1.P 32(XK), [V10.B16, V11.B16]

	AESE  V10.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V10.B16, V1.B16
	AESMC V1.B16, V1.B16

	AESE  V11.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V11.B16, V1.B16
	AESMC V1.B16, V1.B16

Lenc128:
	VLD1.P 64(XK), [V12.B16, V13.B16, V14.B16, V15.B16]
	VLD1.P 64(XK), [V16.B16, V17.B16, V18.B16, V19.B16]
	VLD1.P 48(XK), [V20.B16, V21.B16, V22.B16]

	AESE  V12.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V12.B16, V1.B16
	AESMC V1.B16, V1.B16

	AESE  V13.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V13.B16, V1.B16
	AESMC V1.B16, V1.B16

	AESE  V14.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V14.B16, V1.B16
	AESMC V1.B16, V1.B16

	AESE  V15.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V15.B16, V1.B16
	AESMC V1.B16, V1.B16

	AESE  V16.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V16.B16, V1.B16
	AESMC V1.B16, V1.B16

	AESE  V17.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V17.B16, V1.B16
	AESMC V1.B16, V1.B16

	AESE  V18.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V18.B16, V1.B16
	AESMC V1.B16, V1.B16

	AESE  V19.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V19.B16, V1.B16
	AESMC V1.B16, V1.B16

	AESE  V20.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V20.B16, V1.B16
	AESMC V1.B16, V1.B16

	AESE V21.B16, V0.B16
	AESE V21.B16, V1.B16

	VEOR V0.B16, V22.B16, V0.B16
	VEOR V1.B16, V22.B16, V1.B16

	VLD1.P 32(SRC), [V23.B16, V24.B16]
	VEOR   V23.B16, V0.B16, V23.B16
	VEOR   V24.B16, V1.B16, V24.B16
	VST1.P [V23.B16, V24.B16], 32(DST)

	RET

// func ctrBlocks4Asm(nr int, xk *[60]uint32, dst *[4*16]byte, src *[4*16]byte, ivlo uint64, ivhi uint64)
TEXT ·ctrBlocks4Asm(SB), NOSPLIT, $0
	MOVD nr+0(FP), NR
	MOVD xk+8(FP), XK
	MOVD dst+16(FP), DST
	MOVD src+24(FP), SRC
	MOVD ivlo+32(FP), IV_LOW_LE
	MOVD ivhi+40(FP), IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V0.D[1]
	VMOV IV_HIGH_BE, V0.D[0]
	ADDS $1, IV_LOW_LE
	ADC  $0, IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V1.D[1]
	VMOV IV_HIGH_BE, V1.D[0]
	ADDS $1, IV_LOW_LE
	ADC  $0, IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V2.D[1]
	VMOV IV_HIGH_BE, V2.D[0]
	ADDS $1, IV_LOW_LE
	ADC  $0, IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V3.D[1]
	VMOV IV_HIGH_BE, V3.D[0]

	CMP $12, NR
	BLT Lenc128
	BEQ Lenc192

Lenc256:
	VLD1.P 32(XK), [V8.B16, V9.B16]

	AESE  V8.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V8.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V8.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V8.B16, V3.B16
	AESMC V3.B16, V3.B16

	AESE  V9.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V9.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V9.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V9.B16, V3.B16
	AESMC V3.B16, V3.B16

Lenc192:
	VLD1.P 32(XK), [V10.B16, V11.B16]

	AESE  V10.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V10.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V10.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V10.B16, V3.B16
	AESMC V3.B16, V3.B16

	AESE  V11.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V11.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V11.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V11.B16, V3.B16
	AESMC V3.B16, V3.B16

Lenc128:
	VLD1.P 64(XK), [V12.B16, V13.B16, V14.B16, V15.B16]
	VLD1.P 64(XK), [V16.B16, V17.B16, V18.B16, V19.B16]
	VLD1.P 48(XK), [V20.B16, V21.B16, V22.B16]

	AESE  V12.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V12.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V12.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V12.B16, V3.B16
	AESMC V3.B16, V3.B16

	AESE  V13.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V13.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V13.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V13.B16, V3.B16
	AESMC V3.B16, V3.B16

	AESE  V14.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V14.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V14.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V14.B16, V3.B16
	AESMC V3.B16, V3.B16

	AESE  V15.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V15.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V15.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V15.B16, V3.B16
	AESMC V3.B16, V3.B16

	AESE  V16.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V16.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V16.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V16.B16, V3.B16
	AESMC V3.B16, V3.B16

	AESE  V17.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V17.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V17.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V17.B16, V3.B16
	AESMC V3.B16, V3.B16

	AESE  V18.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V18.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V18.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V18.B16, V3.B16
	AESMC V3.B16, V3.B16

	AESE  V19.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V19.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V19.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V19.B16, V3.B16
	AESMC V3.B16, V3.B16

	AESE  V20.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V20.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V20.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V20.B16, V3.B16
	AESMC V3.B16, V3.B16

	AESE V21.B16, V0.B16
	AESE V21.B16, V1.B16
	AESE V21.B16, V2.B16
	AESE V21.B16, V3.B16

	VEOR V0.B16, V22.B16, V0.B16
	VEOR V1.B16, V22.B16, V1.B16
	VEOR V2.B16, V22.B16, V2.B16
	VEOR V3.B16, V22.B16, V3.B16

	VLD1.P 64(SRC), [V23.B16, V24.B16, V25.B16, V26.B16]
	VEOR   V23.B16, V0.B16, V23.B16
	VEOR   V24.B16, V1.B16, V24.B16
	VEOR   V25.B16, V2.B16, V25.B16
	VEOR   V26.B16, V3.B16, V26.B16
	VST1.P [V23.B16, V24.B16, V25.B16, V26.B16], 64(DST)

	RET

// func ctrBlocks8Asm(nr int, xk *[60]uint32, dst *[8*16]byte, src *[8*16]byte, ivlo uint64, ivhi uint64)
TEXT ·ctrBlocks8Asm(SB), NOSPLIT, $0
	MOVD nr+0(FP), NR
	MOVD xk+8(FP), XK
	MOVD dst+16(FP), DST
	MOVD src+24(FP), SRC
	MOVD ivlo+32(FP), IV_LOW_LE
	MOVD ivhi+40(FP), IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V0.D[1]
	VMOV IV_HIGH_BE, V0.D[0]
	ADDS $1, IV_LOW_LE
	ADC  $0, IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V1.D[1]
	VMOV IV_HIGH_BE, V1.D[0]
	ADDS $1, IV_LOW_LE
	ADC  $0, IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V2.D[1]
	VMOV IV_HIGH_BE, V2.D[0]
	ADDS $1, IV_LOW_LE
	ADC  $0, IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V3.D[1]
	VMOV IV_HIGH_BE, V3.D[0]
	ADDS $1, IV_LOW_LE
	ADC  $0, IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V4.D[1]
	VMOV IV_HIGH_BE, V4.D[0]
	ADDS $1, IV_LOW_LE
	ADC  $0, IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V5.D[1]
	VMOV IV_HIGH_BE, V5.D[0]
	ADDS $1, IV_LOW_LE
	ADC  $0, IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V6.D[1]
	VMOV IV_HIGH_BE, V6.D[0]
	ADDS $1, IV_LOW_LE
	ADC  $0, IV_HIGH_LE

	REV  IV_LOW_LE, IV_LOW_BE
	REV  IV_HIGH_LE, IV_HIGH_BE
	VMOV IV_LOW_BE, V7.D[1]
	VMOV IV_HIGH_BE, V7.D[0]

	CMP $12, NR
	BLT Lenc128
	BEQ Lenc192

Lenc256:
	VLD1.P 32(XK), [V8.B16, V9.B16]

	AESE  V8.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V8.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V8.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V8.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V8.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V8.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V8.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V8.B16, V7.B16
	AESMC V7.B16, V7.B16

	AESE  V9.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V9.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V9.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V9.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V9.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V9.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V9.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V9.B16, V7.B16
	AESMC V7.B16, V7.B16

Lenc192:
	VLD1.P 32(XK), [V10.B16, V11.B16]

	AESE  V10.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V10.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V10.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V10.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V10.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V10.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V10.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V10.B16, V7.B16
	AESMC V7.B16, V7.B16

	AESE  V11.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V11.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V11.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V11.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V11.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V11.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V11.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V11.B16, V7.B16
	AESMC V7.B16, V7.B16

Lenc128:
	VLD1.P 64(XK), [V12.B16, V13.B16, V14.B16, V15.B16]
	VLD1.P 64(XK), [V16.B16, V17.B16, V18.B16, V19.B16]
	VLD1.P 48(XK), [V20.B16, V21.B16, V22.B16]

	AESE  V12.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V12.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V12.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V12.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V12.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V12.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V12.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V12.B16, V7.B16
	AESMC V7.B16, V7.B16

	AESE  V13.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V13.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V13.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V13.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V13.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V13.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V13.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V13.B16, V7.B16
	AESMC V7.B16, V7.B16

	AESE  V14.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V14.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V14.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V14.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V14.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V14.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V14.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V14.B16, V7.B16
	AESMC V7.B16, V7.B16

	AESE  V15.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V15.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V15.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V15.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V15.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V15.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V15.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V15.B16, V7.B16
	AESMC V7.B16, V7.B16

	AESE  V16.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V16.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V16.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V16.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V16.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V16.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V16.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V16.B16, V7.B16
	AESMC V7.B16, V7.B16

	AESE  V17.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V17.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V17.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V17.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V17.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V17.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V17.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V17.B16, V7.B16
	AESMC V7.B16, V7.B16

	AESE  V18.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V18.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V18.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V18.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V18.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V18.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V18.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V18.B16, V7.B16
	AESMC V7.B16, V7.B16

	AESE  V19.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V19.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V19.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V19.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V19.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V19.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V19.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V19.B16, V7.B16
	AESMC V7.B16, V7.B16

	AESE  V20.B16, V0.B16
	AESMC V0.B16, V0.B16
	AESE  V20.B16, V1.B16
	AESMC V1.B16, V1.B16
	AESE  V20.B16, V2.B16
	AESMC V2.B16, V2.B16
	AESE  V20.B16, V3.B16
	AESMC V3.B16, V3.B16
	AESE  V20.B16, V4.B16
	AESMC V4.B16, V4.B16
	AESE  V20.B16, V5.B16
	AESMC V5.B16, V5.B16
	AESE  V20.B16, V6.B16
	AESMC V6.B16, V6.B16
	AESE  V20.B16, V7.B16
	AESMC V7.B16, V7.B16

	AESE V21.B16, V0.B16
	AESE V21.B16, V1.B16
	AESE V21.B16, V2.B16
	AESE V21.B16, V3.B16
	AESE V21.B16, V4.B16
	AESE V21.B16, V5.B16
	AESE V21.B16, V6.B16
	AESE V21.B16, V7.B16

	VEOR V0.B16, V22.B16, V0.B16
	VEOR V1.B16, V22.B16, V1.B16
	VEOR V2.B16, V22.B16, V2.B16
	VEOR V3.B16, V22.B16, V3.B16
	VEOR V4.B16, V22.B16, V4.B16
	VEOR V5.B16, V22.B16, V5.B16
	VEOR V6.B16, V22.B16, V6.B16
	VEOR V7.B16, V22.B16, V7.B16

	VLD1.P 64(SRC), [V23.B16, V24.B16, V25.B16, V26.B16]
	VLD1.P 64(SRC), [V27.B16, V28.B16, V29.B16, V30.B16]
	VEOR   V23.B16, V0.B16, V23.B16
	VEOR   V24.B16, V1.B16, V24.B16
	VEOR   V25.B16, V2.B16, V25.B16
	VEOR   V26.B16, V3.B16, V26.B16
	VEOR   V27.B16, V4.B16, V27.B16
	VEOR   V28.B16, V5.B16, V28.B16
	VEOR   V29.B16, V6.B16, V29.B16
	VEOR   V30.B16, V7.B16, V30.B16
	VST1.P [V23.B16, V24.B16, V25.B16, V26.B16], 64(DST)
	VST1.P [V27.B16, V28.B16, V29.B16, V30.B16], 64(DST)

	RET

